#include "General.h"
#include "ProtectConsoleCommand.h"
#include "DamageableGameObj.h"
#include "CommandLineParser.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "engine_game.h"
#include "ScriptableGameObj.h"
#include "DefenseObjectClass.h"
#include "gmgame.h"
#include "Iterator.h"

static int getClientIdByIdentifier(const char* clientIdentifier)
{
	assert(clientIdentifier);
	const cPlayer* player = Find_Player(atoi(clientIdentifier));
	int result;
	if (player)
		result = player->PlayerId;
	else
		result = -1;
	return result;
}

static bool isClientId(const int id)
{
	return id > 0 && id < 128 && Find_Player(id);
}

class CommandPROTECTPLAYER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "protectplayer"; 
	}
	const char* Get_Help() 
	{ 
		return "PROTECTPLAYER <ID> - Makes a player unkillable until they respawn."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please a player ID.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid player ID.");
			}
			else
			{
				Attach_Script_Once(Get_GameObj(clientId), "ProtectPlayer_Script", "");
			}
		}
	}
};

class CommandUNPROTECTPLAYER :
	public ConsoleFunctionClass
{
public:
	const char* Get_Name() 
	{ 
		return "unprotectplayer"; 
	}
	const char* Get_Help() 
	{ 
		return "UNPROTECTPLAYER <ID> - Makes a player killable again."; 
	}
	void Activate(const char* argumentsString)
	{
		CommandLineParser arguments(argumentsString);
		const char* clientIdentifier = arguments.getString();

		if (!clientIdentifier || clientIdentifier[0] == '\0')
			Console_Output("Please a player ID.");
		else
		{
			const int clientId = getClientIdByIdentifier(clientIdentifier);
			if (!isClientId(clientId))
			{
				Console_Output("Please enter a valid player ID.");
			}
			else
			{
				Commands->Send_Custom_Event(0, Get_GameObj(clientId), 8765, 0, 1.0f);
//				Remove_Script(Get_GameObj(clientId), "ProtectPlayer_Script");
			}
		}
	}
};

class PROTECTCONSOLECOMMAND : public Plugin
{
public:
	PROTECTCONSOLECOMMAND()
	{
		ConsoleFunctionList.Add(new CommandPROTECTPLAYER);
		ConsoleFunctionList.Add(new CommandUNPROTECTPLAYER);
		Sort_Function_List();
		Verbose_Help_File();
	}
	~PROTECTCONSOLECOMMAND()
	{
		const DynamicVectorClass<ConsoleFunctionClass*> consoleFunctions(ConsoleFunctionList);
		TT_FOREACH(consoleFunction, consoleFunctions)
		{
			const char* name = (*consoleFunction)->Get_Name();
			if (name)
			{ 
				if (strcmp(name, "protectplayer") == 0 || strcmp(name, "unprotectplayer") == 0)
				{
					ConsoleFunctionList.Delete(consoleFunction);
				}
			}
		}
	}	
};

void ProtectPlayer_Script::Created(GameObject *obj)
{
	obj->As_DamageableGameObj()->Get_Defense_Object()->Set_Can_Object_Die(false);

	OriginalDamagePoints = Get_Damage_Points(obj);
	Set_Damage_Points(obj, 0.0f);
}

void ProtectPlayer_Script::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	Commands->Set_Health(obj, Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj, Commands->Get_Max_Shield_Strength(obj));
}

void ProtectPlayer_Script:: Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if ( (message == 8765) ) 
	{
		Console_Input("trigged console"); // DEBUG CRAP
		Set_Damage_Points(obj, OriginalDamagePoints);
		obj->As_DamageableGameObj()->Get_Defense_Object()->Set_Can_Object_Die(true);
		Destroy_Script();
	}
}

ScriptRegistrant<ProtectPlayer_Script> ProtectPlayer_Script_Registrant("ProtectPlayer_Script","");

PROTECTCONSOLECOMMAND protectconsolecommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &protectconsolecommand;
}